package gov.va.vinci.dart.db.mock;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import gov.va.vinci.dart.common.exception.ObjectNotFoundException;
import gov.va.vinci.dart.biz.RequestStatus;
import gov.va.vinci.dart.biz.RequestWorkflow;
import gov.va.vinci.dart.db.RequestWorkflowDAO;

public class RequestWorkflowDAOMock implements RequestWorkflowDAO {

	private static HashMap<Integer,RequestWorkflow> IDHash = new HashMap<Integer,RequestWorkflow>();
	private static boolean initialized = false;
	private static int idCounter = 1;
	
	@Override
	public void save(RequestWorkflow workflow) {
		if (workflow == null) {
			throw new IllegalArgumentException();
		}

		initializeWorkflowHash();
		
		if (workflow.getId() == 0) {
			workflow.setId(idCounter++);
		}
		
		IDHash.put(workflow.getId(), workflow);
	}

	@Override
	public void delete(RequestWorkflow workflow) {
		if (workflow == null) {
			throw new IllegalArgumentException();
		}
		
		IDHash.remove(workflow.getId());
	}

	@Override
	public RequestWorkflow findById(int workflowId) {
		initializeWorkflowHash();
		
		return IDHash.get(workflowId);
	}

	@Override
	public RequestWorkflow findOpenByRequestAndWorkflowTemplateId(final int requestId, final int workflowTemplateId) {	
		initializeWorkflowHash();
		
		for (Integer id: IDHash.keySet()) {
			RequestWorkflow workflow = IDHash.get(id);

			try {
				if(	(workflow.getRequest() != null && workflow.getRequest().getId() == requestId) && 
					(workflow.getWorkflowTemplate() != null && workflow.getWorkflowTemplate().getId() == workflowTemplateId) && 
					(workflow.getRequestStatus().getId() != RequestStatus.CLOSED.getId()) ) {	//workflow hasn't been closed
					
					return workflow;

				}//end if
			} catch (ObjectNotFoundException e) {
				e.printStackTrace();
			}
		}

		//throw new ObjectNotFoundException("No workflow found with template id " + workflowTemplateId + " for request id " + requestId);
		return null;	
	}
	
	
	@Override
	public List<RequestWorkflow> listByRequestAndWorkflowTemplateId(final int requestId, final int workflowTemplateId) {
		List<RequestWorkflow> result = new ArrayList<RequestWorkflow>();
		
		initializeWorkflowHash();
		
		for (Integer id: IDHash.keySet()) {
			RequestWorkflow workflow = IDHash.get(id);
			
			if(	(workflow.getRequest() != null && workflow.getRequest().getId() == requestId) && 
				(workflow.getWorkflowTemplate() != null && workflow.getWorkflowTemplate().getId() == workflowTemplateId) ) {

				result.add(workflow);

			}//end if
		}

		return result;	
	}

	
	@Override
	public List<RequestWorkflow> listAll() {
		List<RequestWorkflow> result = new ArrayList<RequestWorkflow>();
		
		initializeWorkflowHash();
		
		for (Integer id: IDHash.keySet()) {
			result.add(IDHash.get(id));
		}

		return result;	
	}

	@Override
	public List<RequestWorkflow> listByRequestId(int requestId) {
		List<RequestWorkflow> result = new ArrayList<RequestWorkflow>();
		
		initializeWorkflowHash();
		
		for (Integer id: IDHash.keySet()) {
			RequestWorkflow workflow = IDHash.get(id);
			if (workflow.getRequest().getId() == requestId) {
				result.add(workflow);
			}
		}

		return result;	
	}

	@Override
	public List<RequestWorkflow> listOpenByRequestId(final int requestId) {
		List<RequestWorkflow> result = new ArrayList<RequestWorkflow>();
		
		initializeWorkflowHash();
		
		for (Integer id: IDHash.keySet()) {
			RequestWorkflow workflow = IDHash.get(id);

			try {
				if (workflow.getRequest().getId() == requestId && 
					workflow.getRequestStatus().getId() != RequestStatus.CLOSED.getId()) {	//workflow hasn't been closed
					result.add(workflow);
				}
			} catch (ObjectNotFoundException e) {
				e.printStackTrace();
			}
		}

		return result;	
	}
	
	
	private void initializeWorkflowHash() {
	
		if (initialized == true) {
			return;
		}
		
		//TODO: may want to create a valid RequestWorkflow to use in the mock framework		
		
		initialized = true;
	}
	

}
